package MusicLandscape;

import MusicLandscape.entities.*;
import MusicLandscape.util.formatters.CSVTrackFormatter;
import MusicLandscape.util.io.MyTrackCSVReader;
import MusicLandscape.util.io.MyWriter;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;

/**
 * Test program to check MusicLandscape entity classes.
 * <p>
 * Does not do anything interesting.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 6
 * @since ExerciseSheet03
 */
public class DemoApp {
    public static void main(String[] args) {
        try {
            MyTrackCSVReader reader = new MyTrackCSVReader(new BufferedReader(new FileReader("demo_tracks.csv")));
            MyWriter<Track> writer = new MyWriter<>(new FileWriter("output.csv"), new CSVTrackFormatter());
            writer.put(reader.get());
            writer.put(reader.get());
            writer.close();
        } catch (FileNotFoundException e) {
            System.out.println("demo_tracks.csv could not be found!");
        } catch (IOException e) {
            System.out.println("IO exception: " + e.getMessage());
        }

        try {
            byte[] input = Files.readAllBytes(Path.of("demo_tracks.csv"));
            byte[] output = Files.readAllBytes(Path.of("output.csv"));

            if (!Arrays.equals(input, output)) {
                System.out.println("CSV output should be exactly equal to input!");
            }
        } catch (Exception ignored) {
        }
    }
}